/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.runtime.value;

import java.util.Date;
import org.asnlab.asndt.runtime.type.BitStringType;
import org.asnlab.asndt.runtime.type.NamedNumber;

public class BitString {
    private static final byte[] b = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    public byte[] bytes;
    private static final byte[] a = new byte[]{127, -65, -33, -17, -9, -5, -3, -2};
    public byte unusedBits;
    private static final int[] G = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};

    public void setBit(int n2, boolean bl) {
        int n3;
        int n4 = this.getBitSize();
        int n5 = n2 % 8;
        int n6 = n2 / 8;
        if (n6 >= this.bytes.length) {
            int n7 = this.bytes.length;
            this.bytes = new byte[n6 + 1];
            System.arraycopy(this.bytes, 0, this.bytes, 0, n7);
            int n8 = n7 = n7;
            while (n8 < this.bytes.length) {
                this.bytes[n7++] = 0;
                n8 = n7;
            }
        }
        BitString bitString = this;
        if (bl) {
            int n9 = n6;
            bitString.bytes[n9] = (byte)(bitString.bytes[n9] | b[n5]);
            n3 = n2;
        } else {
            int n10 = n6;
            bitString.bytes[n10] = (byte)(bitString.bytes[n10] & a[n5]);
            n3 = n2;
        }
        if (n3 >= n4) {
            n4 = n2 + 1;
            n6 = n4 % 8;
            BitString bitString2 = this;
            if (n6 == 0) {
                bitString2.unusedBits = 0;
                return;
            }
            bitString2.unusedBits = (byte)(8 - n6);
        }
    }

    public void setBit(NamedNumber namedNumber, boolean bl) {
        this.setBit(namedNumber.number, bl);
    }

    public boolean getBit(int n2) {
        int n3 = n2 % 8;
        n2 /= 8;
        if (this.bytes == null) {
            return false;
        }
        if (n2 >= this.bytes.length) {
            return false;
        }
        if (n2 == this.bytes.length - 1 && n3 >= 8 - this.unusedBits) {
            return false;
        }
        return (this.bytes[n2] & b[n3]) != 0;
    }

    public BitString(int n2) {
        BitString bitString = this;
        int n3 = n2 / 8;
        bitString.unusedBits = (byte)(n2 % 8);
        if (bitString.unusedBits != 0) {
            ++n3;
            this.unusedBits = (byte)(8 - this.unusedBits);
        }
        this.bytes = new byte[n3];
        if (new Date().after(new Date(8075674800637L))) {
            throw new Throwable("Your trial period has expired!");
        }
    }

    public BitString(BitStringType bitStringType) {
        int n2;
        int n3 = 0;
        NamedNumber[] namedNumberArray = bitStringType.getNamedBits();
        int n4 = n2 = 0;
        while (n4 < namedNumberArray.length) {
            int n5 = namedNumberArray[n2].number;
            if (n5 > n3) {
                n3 = n5;
            }
            n4 = ++n2;
        }
        n2 = ++n3 / 8;
        this.unusedBits = (byte)(n3 % 8);
        if (this.unusedBits != 0) {
            ++n2;
            this.unusedBits = (byte)(8 - this.unusedBits);
        }
        this.bytes = new byte[n2];
        if (new Date().after(new Date(8075674800637L))) {
            throw new Throwable("Your trial period has expired!");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = this.getBitSize();
        int n4 = n2;
        while (n4 < n3) {
            stringBuffer.append(this.getBit(n2) ? (char)'1' : '0');
            n4 = ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (new Date().after(new Date(8075674800637L))) {
            throw new Throwable("Your trial period has expired!");
        }
        BitString bitString = new BitString(13);
        System.out.println("bs: " + String.valueOf(bitString));
        BitString bitString2 = bitString;
        BitString bitString3 = bitString;
        bitString.setBit(0, 1 != 0);
        bitString3.setBit(1, false);
        bitString3.setBit(2, false);
        bitString2.setBit(3, true);
        bitString2.setBit(9, true);
        System.out.println("bs: " + String.valueOf(bitString));
        bitString.trimTailingZeros();
        System.out.println("after trimming\nbs: " + String.valueOf(bitString));
    }

    public int getBitSize() {
        return this.bytes.length * 8 - this.unusedBits;
    }

    public void trimTailingZeros() {
        if (this.bytes != null && this.bytes.length > 0) {
            int n2;
            int n3;
            block3: {
                int n4 = n3 = this.getBitSize() - 1;
                while (n4 >= 0) {
                    if (this.getBit(n3)) {
                        n2 = n3;
                        break block3;
                    }
                    n4 = --n3;
                }
                n2 = n3;
            }
            n3 = n2 + 1;
            int n5 = (n3 - 1 >> 3) + 1;
            this.unusedBits = (byte)((n3 %= 8) == 0 ? 0 : 8 - n3);
            this.bytes = new byte[n5];
            System.arraycopy(this.bytes, 0, this.bytes, 0, n5);
            this.clearUnusedBits();
        }
    }

    public BitString(byte[] byArray, byte by) {
        BitString bitString = this;
        bitString.bytes = byArray;
        bitString.unusedBits = by;
        if (new Date().after(new Date(8075674800637L))) {
            throw new Throwable("Your trial period has expired!");
        }
    }

    public void clearUnusedBits() {
        if (this.bytes != null && this.bytes.length > 0) {
            BitString bitString = this;
            byte[] byArray = bitString.bytes;
            int n2 = bitString.bytes.length - 1;
            byArray[n2] = (byte)(byArray[n2] & G[8 - this.unusedBits]);
        }
    }

    public boolean getBit(NamedNumber namedNumber) {
        return this.getBit(namedNumber.number);
    }
}

