/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICodeAssist;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SelectionConverter {
    private static final IAsnElement[] EMPTY_RESULT = new IAsnElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws AsnModelException {
        ISelection selection;
        if (part instanceof AsnEditor) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((AsnEditor)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IAsnElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IAsnElement[] result = new IAsnElement[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof IAsnElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IAsnElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(AsnEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IAsnElement[] codeResolveOrInputForked(AsnEditor editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IAsnElement input = SelectionConverter.getInput(editor);
        IAsnElement[] result = SelectionConverter.performForkedCodeResolve(input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new IAsnElement[]{input};
        }
        return result;
    }

    public static IAsnElement[] codeResolve(AsnEditor editor) throws AsnModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IAsnElement[] codeResolve(AsnEditor editor, boolean primaryOnly) throws AsnModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IAsnElement[] codeResolveForked(AsnEditor editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IAsnElement getElementAtOffset(AsnEditor editor) throws AsnModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IAsnElement getElementAtOffset(AsnEditor editor, boolean primaryOnly) throws AsnModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor, primaryOnly), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static IAsnElement getInput(AsnEditor editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static IAsnElement getInput(AsnEditor editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputAsnElement((IEditorPart)editor, primaryOnly);
    }

    public static ICompilationUnit getInputAsCompilationUnit(AsnEditor editor) {
        IAsnElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ICompilationUnit) {
            return (ICompilationUnit)editorInput;
        }
        return null;
    }

    private static IAsnElement[] performForkedCodeResolve(IAsnElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IAsnElement[] result;
            private final /* synthetic */ IAsnElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IAsnElement iAsnElement, ITextSelection iTextSelection) {
                this.val$input = iAsnElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (AsnModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IAsnElement[] codeResolve(IAsnElement input, ITextSelection selection) throws AsnModelException {
        if (input instanceof ICodeAssist) {
            IAsnElement[] elements;
            if (input instanceof ICompilationUnit) {
                AsnModelUtil.reconcile((ICompilationUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IAsnElement getElementAtOffset(IAsnElement input, ITextSelection selection) throws AsnModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            AsnModelUtil.reconcile(cunit);
            IAsnElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IAsnElement resolveEnclosingElement(AsnEditor editor, ITextSelection selection) throws AsnModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(editor), selection);
    }

    public static IAsnElement resolveEnclosingElement(IAsnElement input, ITextSelection selection) throws AsnModelException {
        IAsnElement atOffset = null;
        if (!(input instanceof ICompilationUnit)) {
            return null;
        }
        ICompilationUnit cunit = (ICompilationUnit)input;
        AsnModelUtil.reconcile(cunit);
        atOffset = cunit.getElementAt(selection.getOffset());
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IAsnElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }
}

