/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorMessages;
import org.asnlab.asndt.ui.AsnElementLabels;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AsnElementHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IAsnElement fElement;
    private final boolean fQualify;

    public AsnElementHyperlink(IRegion region, SelectionDispatchAction openAction, IAsnElement element, boolean qualify) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fElement = element;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)this.fElement));
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            String elementLabel = AsnElementLabels.getElementLabel(this.fElement);
            return Messages.format(AsnEditorMessages.AsnElementHyperlink_hyperlinkText_qualified, new Object[]{elementLabel});
        }
        return AsnEditorMessages.AsnElementHyperlink_hyperlinkText;
    }
}

