/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor.selectionactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.IModuleDefinition;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.corext.SourceRange;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionActionMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class GoToNextPreviousMemberAction
extends Action
implements IUpdate {
    public static final String NEXT_MEMBER = "GoToNextMember";
    public static final String PREVIOUS_MEMBER = "GoToPreviousMember";
    private AsnEditor fEditor;
    private boolean fIsGotoNext;

    public static GoToNextPreviousMemberAction newGoToNextMemberAction(AsnEditor editor) {
        String text = SelectionActionMessages.GotoNextMember_label;
        return new GoToNextPreviousMemberAction(editor, text, true);
    }

    public static GoToNextPreviousMemberAction newGoToPreviousMemberAction(AsnEditor editor) {
        String text = SelectionActionMessages.GotoPreviousMember_label;
        return new GoToNextPreviousMemberAction(editor, text, false);
    }

    private GoToNextPreviousMemberAction(AsnEditor editor, String text, boolean isGotoNext) {
        super(text);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fIsGotoNext = isGotoNext;
        this.update();
        if (isGotoNext) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.goto_next_member_action");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.goto_previous_member_action");
        }
    }

    public GoToNextPreviousMemberAction(boolean isSelectNext) {
        super("");
        this.fIsGotoNext = isSelectNext;
    }

    public void update() {
        boolean enabled = false;
        ISourceReference ref = this.getSourceReference();
        if (ref != null) {
            try {
                ISourceRange range = ref.getSourceRange();
                enabled = range != null && range.getLength() > 0;
            }
            catch (AsnModelException asnModelException) {}
        }
        this.setEnabled(enabled);
    }

    public final void run() {
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(GoToNextPreviousMemberAction.createSourceRange(selection), null);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
    }

    private IModuleDefinition[] getModules() throws AsnModelException {
        IEditorInput input = this.fEditor.getEditorInput();
        return AsnPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input).getModuleDefinitions();
    }

    private ISourceReference getSourceReference() {
        IEditorInput input = this.fEditor.getEditorInput();
        return AsnPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    public ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, IModuleDefinition[] modules) {
        try {
            Object[] offsetArray;
            if (modules == null) {
                modules = this.getModules();
            }
            if ((offsetArray = GoToNextPreviousMemberAction.createOffsetArray(modules)).length == 0) {
                return oldSourceRange;
            }
            Arrays.sort(offsetArray);
            Integer oldOffset = new Integer(oldSourceRange.getOffset());
            int index = Arrays.binarySearch(offsetArray, oldOffset);
            if (this.fIsGotoNext) {
                return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getNextOffset(index, (Integer[])offsetArray, oldOffset));
            }
            return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getPreviousOffset(index, (Integer[])offsetArray, oldOffset));
        }
        catch (AsnModelException e) {
            AsnPlugin.log(e);
            return oldSourceRange;
        }
    }

    private static Integer getPreviousOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return oldOffset;
        }
        if (index == 0) {
            return offsetArray[0];
        }
        if (index > 0) {
            return offsetArray[index - 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        return offsetArray[absIndex - 2];
    }

    private static Integer getNextOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return offsetArray[0];
        }
        if (index == 0) {
            if (offsetArray.length != 1) {
                return offsetArray[1];
            }
            return offsetArray[0];
        }
        if (index > 0) {
            if (index == offsetArray.length - 1) {
                return oldOffset;
            }
            return offsetArray[index + 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        if (absIndex > offsetArray.length) {
            return oldOffset;
        }
        return offsetArray[absIndex - 1];
    }

    private static ISourceRange createNewSourceRange(Integer offset) {
        return new SourceRange(offset, 0);
    }

    private static Integer[] createOffsetArray(IModuleDefinition[] modules) throws AsnModelException {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < modules.length) {
            IModuleDefinition iType = modules[i];
            GoToNextPreviousMemberAction.addOffset(result, iType.getNameRange().getOffset());
            GoToNextPreviousMemberAction.addOffset(result, iType.getSourceRange().getOffset() + iType.getSourceRange().getLength());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getTypes());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getValues());
            ++i;
        }
        return result.toArray(new Integer[result.size()]);
    }

    private static void addMemberOffsetList(List result, IMember[] members) throws AsnModelException {
        int i = 0;
        while (i < members.length) {
            GoToNextPreviousMemberAction.addOffset(result, GoToNextPreviousMemberAction.getOffset(members[i]));
            ++i;
        }
    }

    private static int getOffset(IMember iMember) throws AsnModelException {
        if (iMember.getNameRange() != null && iMember.getNameRange().getOffset() >= 0) {
            return iMember.getNameRange().getOffset();
        }
        return iMember.getSourceRange().getOffset();
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static void addOffset(List result, int offset) {
        if (offset >= 0) {
            result.add(new Integer(offset));
        }
    }
}

