/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.console;

import org.asnlab.asndt.core.compiler.BuildOutputProvider;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.console.AsnBuildConsoleFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnBuildOutputConsole
extends BuildOutputProvider {
    private int fLength = 0;

    public void clear() {
        MessageConsole console = AsnBuildConsoleFactory.getConsole();
        console.clearConsole();
        this.fLength = 0;
    }

    public void info(String message) {
        MessageConsole console = AsnBuildConsoleFactory.getConsole();
        MessageConsoleStream stream = console.newMessageStream();
        stream.setActivateOnWrite(true);
        stream.setEncoding("UTF-8");
        this.fLength += message.length();
        stream.print(message);
    }

    public void warn(String message, IPath path, int offset, int length) {
        MessageConsole console = AsnBuildConsoleFactory.getConsole();
        MessageConsoleStream stream = console.newMessageStream();
        stream.setActivateOnWrite(true);
        stream.setEncoding("UTF-8");
        stream.print(message);
        AsnFileHyperLink link = new AsnFileHyperLink(message, path, offset, length);
        console.getDocument().addDocumentListener((IDocumentListener)new DocumentChangeListener(console, link, this.fLength += message.length()));
    }

    public void error(String message, IPath path, int offset, int length) {
        MessageConsole console = AsnBuildConsoleFactory.getConsole();
        MessageConsoleStream stream = console.newMessageStream();
        stream.setActivateOnWrite(true);
        stream.setEncoding("UTF-8");
        stream.print(message);
        AsnFileHyperLink link = new AsnFileHyperLink(message, path, offset, length);
        console.getDocument().addDocumentListener((IDocumentListener)new DocumentChangeListener(console, link, this.fLength += message.length()));
    }

    static class AsnFileHyperLink
    implements IHyperlink {
        private String fText;
        private IPath fPath;
        private int fFileOffset;
        private int fFileLength;
        private IFile fFile;
        private int fFileLineNumber;
        private String fEditorId;

        public AsnFileHyperLink(String text, IPath path, int fileOffset, int fileLength) {
            this.fText = text;
            this.fPath = path;
            this.fFileOffset = fileOffset;
            this.fFileLength = fileLength;
        }

        public void linkActivated() {
            block7: {
                IWorkbenchPage page;
                this.fFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                IWorkbenchWindow window = AsnPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    try {
                        IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput(this.fFile), this.getEditorId(), true);
                        if (this.fFileOffset < 0 || this.fFileLength < 0) break block7;
                        ITextEditor textEditor = null;
                        textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                        if (textEditor == null) break block7;
                        textEditor.selectAndReveal(this.fFileOffset, this.fFileLength);
                        IEditorInput input = editorPart.getEditorInput();
                        IDocumentProvider provider = textEditor.getDocumentProvider();
                        try {
                            provider.connect((Object)input);
                        }
                        catch (CoreException e) {
                            AsnPlugin.log(e);
                            return;
                        }
                        IDocument document = provider.getDocument((Object)input);
                        try {
                            this.fFileLineNumber = document.getLineOfOffset(this.fFileOffset);
                        }
                        catch (BadLocationException e) {
                            AsnPlugin.log(e);
                        }
                        provider.disconnect((Object)input);
                    }
                    catch (PartInitException e) {
                        AsnPlugin.log(e);
                    }
                }
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        private String getEditorId() {
            if (this.fEditorId == null) {
                IWorkbench workbench = AsnPlugin.getDefault().getWorkbench();
                IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(this.fFile.getName(), this.getFileContentType());
                if (desc == null) {
                    desc = workbench.getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
                }
                this.fEditorId = desc.getId();
            }
            return this.fEditorId;
        }

        private IContentType getFileContentType() {
            try {
                IContentDescription description = this.fFile.getContentDescription();
                if (description != null) {
                    return description.getContentType();
                }
            }
            catch (CoreException coreException) {}
            return null;
        }
    }

    static class DocumentChangeListener
    implements IDocumentListener {
        int expectedlen;
        final AsnFileHyperLink link;
        MessageConsole console;

        public DocumentChangeListener(MessageConsole console, AsnFileHyperLink link, int expectedlen) {
            this.console = console;
            this.link = link;
            this.expectedlen = expectedlen;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            int strLenAfterChange = event.getDocument().getLength();
            if (strLenAfterChange >= this.expectedlen) {
                Job job = new Job("addLinkToConsole"){

                    public IStatus run(IProgressMonitor monitor) {
                        try {
                            console.addHyperlink((IHyperlink)link, expectedlen - link.fText.length(), link.fText.length());
                        }
                        catch (Exception exception) {}
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                event.getDocument().removeDocumentListener((IDocumentListener)this);
            }
        }
    }
}

