/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.text.AsnWordFinder;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class AsnElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private AsnEditor fEditor;
    private boolean fUseCodeResolve = false;

    public AsnElementProvider(IEditorPart editor) {
        if (editor instanceof AsnEditor) {
            this.fEditor = (AsnEditor)editor;
        }
    }

    public AsnElementProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = AsnWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection sel;
            if (this.fUseCodeResolve && !(sel = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return sel.getFirstElement();
            }
            IAsnElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                return element;
            }
            return EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false);
        }
        catch (AsnModelException asnModelException) {
            return null;
        }
    }
}

