/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn.hover;

import java.io.IOException;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.corext.codemanipulation.StubUtility;
import org.asnlab.asndt.internal.corext.util.Strings;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.AsnCodeReader;
import org.asnlab.asndt.internal.ui.text.asn.hover.AbstractAsnEditorTextHover;
import org.asnlab.asndt.internal.ui.text.asn.hover.SourceViewerInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class AsnSourceHover
extends AbstractAsnEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    @Override
    protected String getHoverInfo(IAsnElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IAsnElement curr = result[0];
        if (curr instanceof IMember && curr instanceof ISourceReference) {
            String source;
            block7: {
                try {
                    source = ((ISourceReference)curr).getSource();
                    if (source != null) break block7;
                    return null;
                }
                catch (AsnModelException asnModelException) {}
            }
            source = this.removeLeadingComments(source);
            String delim = StubUtility.getLineDelimiterUsed(result[0]);
            String[] sourceLines = Strings.convertIntoLines(source);
            String firstLine = sourceLines[0];
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = "";
            }
            Strings.trimIndentation(sourceLines, curr.getAsnProject());
            if (!Character.isWhitespace(firstLine.charAt(0))) {
                sourceLines[0] = firstLine;
            }
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    private String removeLeadingComments(String source) {
        int i;
        block16: {
            AsnCodeReader reader = new AsnCodeReader();
            Document document = new Document(source);
            try {
                try {
                    reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
                    int c = reader.read();
                    while (c != -1 && (c == 13 || c == 10)) {
                        c = reader.read();
                    }
                    i = reader.getOffset();
                    reader.close();
                }
                catch (IOException iOException) {
                    i = 0;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block16;
                    }
                    catch (IOException ex) {
                        AsnPlugin.log(ex);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    AsnPlugin.log(ex);
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AsnPlugin.log(ex);
            }
        }
        if (i < 0) {
            return source;
        }
        return source.substring(i);
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = AsnSourceHover.this.getEditor();
                int shellStyle = 12;
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, 0, AsnSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 768;
                int shellStyle = 20;
                IEditorPart editor = AsnSourceHover.this.getEditor();
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

