/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.util;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.core.compiler.CharOperation;
import org.asnlab.asndt.internal.corext.CorextMessages;
import org.asnlab.asndt.internal.corext.ValidateEditException;
import org.asnlab.asndt.internal.corext.util.Resources;
import org.asnlab.asndt.internal.ui.AsnUIStatus;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class AsnModelUtil {
    public static final String DEFAULT_CU_SUFFIX = ".asn";

    public static IAsnElement findInCompilationUnit(ICompilationUnit cu, IAsnElement element) {
        IAsnElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isEditable(ICompilationUnit cu) {
        Assert.isNotNull((Object)cu);
        IResource resource = cu.getPrimary().getResource();
        return resource.exists() && !resource.getResourceAttributes().isReadOnly();
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean isExceptionToBeLogged(CoreException exception) {
        if (!(exception instanceof AsnModelException)) {
            return true;
        }
        AsnModelException je = (AsnModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IAsnElement[] elements = je.getAsnModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IAsnElement element = elements[i];
            if (element.getElementType() != 5) {
                ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
                if (unit == null) {
                    return true;
                }
                if (!unit.isWorkingCopy()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void reconcile(ICompilationUnit unit) throws AsnModelException {
        unit.reconcile(false, null, null);
    }

    public static String getRenamedCUName(ICompilationUnit cu, String newMainName) {
        String oldName = cu.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return newMainName + oldName.substring(i);
        }
        return newMainName;
    }

    public static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CorextMessages.AsnModelUtil_applyedit_operation, 3);
        try {
            if (!save && AsnModelUtil.isEmpty(edit)) {
                return;
            }
            IDocument document = null;
            DocumentRewriteSession session = null;
            try {
                try {
                    document = AsnModelUtil.aquireDocument(cu, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (document instanceof IDocumentExtension4) {
                        session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                    }
                    if (save) {
                        AsnModelUtil.commitDocument(cu, document, edit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        edit.apply(document);
                    }
                }
                catch (BadLocationException e) {
                    throw new CoreException(AsnUIStatus.createError(4, e));
                }
            }
            catch (Throwable throwable) {
                try {
                    if (session != null && document != null) {
                        ((IDocumentExtension4)document).stopRewriteSession(session);
                    }
                }
                finally {
                    AsnModelUtil.releaseDocument(cu, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                throw throwable;
            }
            try {
                if (session != null && document != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
            }
            finally {
                AsnModelUtil.releaseDocument(cu, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static boolean isEmpty(TextEdit edit) {
        return edit instanceof MultiTextEdit && !((MultiTextEdit)edit).hasChildren();
    }

    private static IDocument aquireDocument(ICompilationUnit cu, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (AsnModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, monitor);
            return bufferManager.getTextFileBuffer(path).getDocument();
        }
        monitor.done();
        return new Document(cu.getSource());
    }

    private static void commitDocument(ICompilationUnit cu, IDocument document, TextEdit edit, IProgressMonitor monitor) throws CoreException, MalformedTreeException, BadLocationException {
        IFile file;
        if (AsnModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            edit.apply(document);
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.getTextFileBuffer(file.getFullPath()).commit(monitor, true);
            return;
        }
        edit.apply(document);
    }

    private static void releaseDocument(ICompilationUnit cu, IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (AsnModelUtil.isPrimary(cu) && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.disconnect(file.getFullPath(), monitor);
            return;
        }
        cu.getBuffer().setContents(document.get());
        monitor.done();
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if ("java.lang".equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String typeName = AsnCore.removeAsnLikeExtension((String)cu.getElementName());
        String mainTypeName = AsnModelUtil.concatenateName(packageName, typeName);
        return qualifier.equals(mainTypeName);
    }

    public static ISourceFolder getSourceFolder(IAsnElement elem) {
        return (ISourceFolder)elem.getAncestor(4);
    }
}

