/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.actions.CategoryFilterActionGroup;
import org.asnlab.asndt.internal.ui.text.AbstractInformationControl;
import org.asnlab.asndt.internal.ui.text.TextMessages;
import org.asnlab.asndt.internal.ui.util.StringMatcher;
import org.asnlab.asndt.internal.ui.viewsupport.AsnUILabelProvider;
import org.asnlab.asndt.internal.ui.viewsupport.MemberFilter;
import org.asnlab.asndt.ui.ProblemsLabelDecorator;
import org.asnlab.asndt.ui.StandardAsnElementContentProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.SWTKeySupport;

public class AsnOutlineInformationControl
extends AbstractInformationControl {
    private KeyAdapter fKeyAdapter;
    private OutlineContentProvider fOutlineContentProvider;
    private IAsnElement fInput = null;
    private OutlineSorter fOutlineSorter;
    private OutlineLabelProvider fInnerLabelProvider;
    private LexicalSortingAction fLexicalSortingAction;
    private CategoryFilterActionGroup fCategoryFilterActionGroup;

    public AsnOutlineInformationControl(Shell parent, int shellStyle, int treeStyle, String commandId) {
        super(parent, shellStyle, treeStyle, commandId, true);
    }

    @Override
    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        text.addKeyListener((KeyListener)this.getKeyAdapter());
        return text;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        OutlineTreeViewer treeViewer = new OutlineTreeViewer(tree);
        treeViewer.addFilter(new AbstractInformationControl.NamePatternFilter());
        treeViewer.addFilter(new MemberFilter());
        this.fInnerLabelProvider = new OutlineLabelProvider();
        this.fInnerLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        treeViewer.setLabelProvider((IBaseLabelProvider)this.fInnerLabelProvider);
        this.fLexicalSortingAction = new LexicalSortingAction(treeViewer);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup((StructuredViewer)treeViewer, this.getId(), this.getInputForCategories());
        this.fOutlineContentProvider = new OutlineContentProvider();
        treeViewer.setContentProvider((IContentProvider)this.fOutlineContentProvider);
        this.fOutlineSorter = new OutlineSorter();
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getTree().addKeyListener((KeyListener)this.getKeyAdapter());
        return treeViewer;
    }

    @Override
    protected String getId() {
        return "org.asnlab.asndt.internal.ui.text.QuickOutline";
    }

    @Override
    public void setInput(Object information) {
        if (information == null || information instanceof String) {
            this.inputChanged(null, null);
            return;
        }
        IAsnElement je = (IAsnElement)information;
        ICompilationUnit cu = (ICompilationUnit)je.getAncestor(5);
        if (cu != null) {
            this.fInput = cu;
        }
        this.inputChanged(this.fInput, information);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
    }

    private KeyAdapter getKeyAdapter() {
        if (this.fKeyAdapter == null) {
            this.fKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    KeySequence[] sequences = AsnOutlineInformationControl.this.getInvokingCommandKeySequences();
                    if (sequences == null) {
                        return;
                    }
                    int i = 0;
                    while (i < sequences.length) {
                        if (sequences[i].equals((Object)keySequence)) {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            };
        }
        return this.fKeyAdapter;
    }

    @Override
    protected void fillViewMenu(IMenuManager viewMenu) {
        super.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.fLexicalSortingAction);
        this.fCategoryFilterActionGroup.setInput(this.getInputForCategories());
        this.fCategoryFilterActionGroup.contributeToViewMenu(viewMenu);
    }

    @Override
    protected void setMatcherString(String pattern, boolean update) {
        if (pattern.length() == 0) {
            super.setMatcherString(pattern, update);
            return;
        }
        boolean ignoreCase = pattern.toLowerCase().equals(pattern);
        String pattern2 = "*-" + pattern;
        this.fStringMatcher = new OrStringMatcher(pattern, pattern2, ignoreCase, false);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private IAsnElement[] getInputForCategories() {
        if (this.fInput == null) {
            return new IAsnElement[0];
        }
        return new IAsnElement[]{this.fInput};
    }

    private IProgressMonitor getProgressMonitor() {
        IWorkbenchPage wbPage = AsnPlugin.getActivePage();
        if (wbPage == null) {
            return null;
        }
        IEditorPart editor = wbPage.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private class LexicalSortingAction
    extends Action {
        private static final String STORE_LEXICAL_SORTING_CHECKED = "LexicalSortingAction.isChecked";
        private TreeViewer fOutlineViewer;

        private LexicalSortingAction(TreeViewer outlineViewer) {
            super(TextMessages.AsnOutlineInformationControl_LexicalSortingAction_label, 2);
            this.setToolTipText(TextMessages.AsnOutlineInformationControl_LexicalSortingAction_tooltip);
            this.setDescription(TextMessages.AsnOutlineInformationControl_LexicalSortingAction_description);
            AsnPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.fOutlineViewer = outlineViewer;
            boolean checked = AsnOutlineInformationControl.this.getDialogSettings().getBoolean(STORE_LEXICAL_SORTING_CHECKED);
            this.setChecked(checked);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.lexical_sorting_browsing_action");
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LexicalSortingAction.this.fOutlineViewer.setSorter(LexicalSortingAction.this.isChecked() ? ((LexicalSortingAction)LexicalSortingAction.this).AsnOutlineInformationControl.this.fOutlineSorter : null);
                }
            });
            if (store) {
                AsnOutlineInformationControl.this.getDialogSettings().put(STORE_LEXICAL_SORTING_CHECKED, on);
            }
        }
    }

    private static class OrStringMatcher
    extends StringMatcher {
        private StringMatcher fMatcher1;
        private StringMatcher fMatcher2;

        private OrStringMatcher(String pattern1, String pattern2, boolean ignoreCase, boolean foo) {
            super("", false, false);
            this.fMatcher1 = new StringMatcher(pattern1, ignoreCase, false);
            this.fMatcher2 = new StringMatcher(pattern2, ignoreCase, false);
        }

        @Override
        public boolean match(String text) {
            return this.fMatcher2.match(text) || this.fMatcher1.match(text);
        }
    }

    private class OutlineContentProvider
    extends StandardAsnElementContentProvider {
        private OutlineContentProvider() {
        }

        @Override
        public void dispose() {
            super.dispose();
            if (AsnOutlineInformationControl.this.fCategoryFilterActionGroup != null) {
                AsnOutlineInformationControl.this.fCategoryFilterActionGroup.dispose();
                AsnOutlineInformationControl.this.fCategoryFilterActionGroup = null;
            }
        }
    }

    private class OutlineLabelProvider
    extends AsnUILabelProvider {
        private OutlineLabelProvider() {
        }

        @Override
        public Color getForeground(Object element) {
            return null;
        }
    }

    private class OutlineSorter
    extends ViewerSorter {
        private OutlineSorter() {
        }
    }

    private class OutlineTreeViewer
    extends TreeViewer {
        private boolean fIsFiltering;

        private OutlineTreeViewer(Tree tree) {
            super(tree);
            this.fIsFiltering = false;
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] result = this.getRawChildren(parent);
            int unfilteredChildren = result.length;
            ViewerFilter[] filters = this.getFilters();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    result = filters[i].filter((Viewer)this, parent, result);
                    ++i;
                }
            }
            this.fIsFiltering = unfilteredChildren != result.length;
            return result;
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IAsnElement ae;
            Item i;
            if (!this.fIsFiltering && node instanceof Item && (i = (Item)node).getData() instanceof IAsnElement && ((ae = (IAsnElement)i.getData()).getElementType() == 17 || ae.getElementType() == 18)) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }
    }
}

