/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.wizards;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModel;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.dialogs.StatusInfo;
import org.asnlab.asndt.internal.ui.viewsupport.IViewPartInputProvider;
import org.asnlab.asndt.internal.ui.wizards.NewWizardMessages;
import org.asnlab.asndt.internal.ui.wizards.TypedElementSelectionValidator;
import org.asnlab.asndt.internal.ui.wizards.TypedViewerFilter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.DialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.asnlab.asndt.ui.AsnElementLabelProvider;
import org.asnlab.asndt.ui.AsnElementSorter;
import org.asnlab.asndt.ui.StandardAsnElementContentProvider;
import org.asnlab.asndt.ui.wizards.NewElementWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus fContainerStatus;
    private StringButtonDialogField fContainerDialogField;
    private ISourceFolder fCurrRoot;
    private IWorkspaceRoot fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fContainerDialogField.setLabelText(this.getContainerLabel());
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.fContainerStatus = new StatusInfo();
        this.fCurrRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IAsnElement elem) {
        ISourceFolder initRoot = null;
        if (elem != null) {
            initRoot = AsnModelUtil.getSourceFolder(elem);
            try {
                IAsnProject aproject;
                if (initRoot == null && (aproject = elem.getAsnProject()) != null) {
                    ISourceFolder[] roots;
                    int i;
                    initRoot = null;
                    if (aproject.exists() && (i = 0) < (roots = aproject.getSourceFolders()).length) {
                        initRoot = roots[i];
                    }
                    if (initRoot == null) {
                        initRoot = aproject.findSourceFolder(aproject.getResource().getFullPath());
                    }
                }
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e);
            }
        }
        this.setSourceFolder(initRoot, true);
    }

    protected IAsnElement getInitialAsnElement(IStructuredSelection selection) {
        Object selectedElement;
        IAsnProject aelem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            aelem = AsnCore.create((IResource)resource);
        }
        if (aelem == null) {
            Object elem;
            IWorkbenchPart part = AsnPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = AsnPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IAsnElement) {
                aelem = (IAsnElement)elem;
            }
        }
        if (aelem == null || aelem.getElementType() == 1) {
            try {
                IAsnProject[] projects = AsnCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getAsnProjects();
                if (projects.length == 1) {
                    aelem = projects[0];
                }
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e);
            }
        }
        return aelem;
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = AsnPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.fContainerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.fContainerDialogField.setFocus();
    }

    private void containerChangeControlPressed(DialogField field) {
        ISourceFolder root = this.chooseContainer();
        if (root != null) {
            this.setSourceFolder(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.fContainerDialogField) {
            this.fContainerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrRoot = null;
        String str = this.getSourceFolderText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, proj.getFullPath().toString()));
                    return status;
                }
                IAsnProject aproject = AsnCore.create((IProject)proj);
                this.fCurrRoot = aproject.findSourceFolder((IPath)path);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.asnlab.asndt.core.asnnature")) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAAsnProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAAsnProject);
                            }
                            return status;
                        }
                        if (!aproject.isOnBuildPath((IAsnElement)this.fCurrRoot)) {
                            status.setWarning(Messages.format(NewWizardMessages.NewContainerWizardPage_warning_NotOnBuildPath, str));
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAAsnProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, str));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public ISourceFolder getSourceFolder() {
        return this.fCurrRoot;
    }

    public String getSourceFolderText() {
        return this.fContainerDialogField.getText();
    }

    public void setSourceFolder(ISourceFolder sourceFolder, boolean canBeModified) {
        this.fCurrRoot = sourceFolder;
        String str = sourceFolder == null ? "" : sourceFolder.getPath().makeRelative().toString();
        this.fContainerDialogField.setText(str);
        this.fContainerDialogField.setEnabled(canBeModified);
    }

    protected ISourceFolder chooseContainer() {
        ISourceFolder initElement = this.getSourceFolder();
        Class[] acceptedClasses = new Class[]{ISourceFolder.class, IAsnProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            @Override
            public boolean isSelectedValid(Object element) {
                if (element instanceof IAsnProject) {
                    IAsnProject jproject = (IAsnProject)element;
                    IPath path = jproject.getProject().getFullPath();
                    return jproject.findSourceFolder(path) != null;
                }
                if (element instanceof ISourceFolder) {
                    return true;
                }
                return true;
            }
        };
        acceptedClasses = new Class[]{IAsnModel.class, ISourceFolder.class, IAsnProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof ISourceFolder) {
                    return true;
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardAsnElementContentProvider provider = new StandardAsnElementContentProvider();
        AsnElementLabelProvider labelProvider = new AsnElementLabelProvider(AsnElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new AsnElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)AsnCore.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IAsnProject) {
                IAsnProject jproject = (IAsnProject)element;
                return jproject.findSourceFolder(jproject.getProject().getFullPath());
            }
            if (element instanceof ISourceFolder) {
                return (ISourceFolder)element;
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }
}

