/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.base;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISymbolsFromModule;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.internal.corext.SourceRange;
import org.asnlab.asndt.internal.corext.dom.Selection;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public abstract class AsnStatusContext
extends RefactoringStatusContext {
    public static RefactoringStatusContext create(IMember member) {
        if (member == null || !member.exists()) {
            return null;
        }
        return new MemberSourceContext(member);
    }

    public static RefactoringStatusContext create(ISymbolsFromModule declaration) {
        if (declaration == null || !declaration.exists()) {
            return null;
        }
        return new ImportDeclarationSourceContext(declaration);
    }

    public static RefactoringStatusContext create(ICompilationUnit cunit) {
        return AsnStatusContext.create(cunit, null);
    }

    public static RefactoringStatusContext create(ICompilationUnit cunit, ISourceRange range) {
        if (cunit == null) {
            return null;
        }
        return new CompilationUnitSourceContext(cunit, range);
    }

    public static RefactoringStatusContext create(ICompilationUnit cunit, ASTNode node) {
        SourceRange range = null;
        if (node != null) {
            range = new SourceRange(node.getSourceStart(), node.getSourceEnd() - node.getSourceStart() + 1);
        }
        return AsnStatusContext.create(cunit, range);
    }

    public static RefactoringStatusContext create(ICompilationUnit cunit, Selection selection) {
        SourceRange range = null;
        if (selection != null) {
            range = new SourceRange(selection.getOffset(), selection.getLength());
        }
        return AsnStatusContext.create(cunit, range);
    }

    public abstract ICompilationUnit getCompilationUnit();

    public abstract ISourceRange getSourceRange();

    public Object getCorrespondingElement() {
        return this.getCompilationUnit();
    }

    private static class CompilationUnitSourceContext
    extends AsnStatusContext {
        private ICompilationUnit fCUnit;
        private ISourceRange fSourceRange;

        private CompilationUnitSourceContext(ICompilationUnit cunit, ISourceRange range) {
            this.fCUnit = cunit;
            this.fSourceRange = range;
            if (this.fSourceRange == null) {
                this.fSourceRange = new SourceRange(0, 0);
            }
        }

        public boolean isBinary() {
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.fCUnit;
        }

        @Override
        public ISourceRange getSourceRange() {
            return this.fSourceRange;
        }

        public String toString() {
            return String.valueOf(this.getSourceRange()) + " in " + super.toString();
        }
    }

    private static class ImportDeclarationSourceContext
    extends AsnStatusContext {
        private ISymbolsFromModule fImportDeclartion;

        private ImportDeclarationSourceContext(ISymbolsFromModule declaration) {
            this.fImportDeclartion = declaration;
        }

        public boolean isBinary() {
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return (ICompilationUnit)this.fImportDeclartion.getParent().getParent();
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fImportDeclartion.getSourceRange();
            }
            catch (AsnModelException asnModelException) {
                return new SourceRange(0, 0);
            }
        }
    }

    private static class MemberSourceContext
    extends AsnStatusContext {
        private IMember fMember;

        private MemberSourceContext(IMember member) {
            this.fMember = member;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return this.fMember.getCompilationUnit();
        }

        @Override
        public ISourceRange getSourceRange() {
            try {
                return this.fMember.getSourceRange();
            }
            catch (AsnModelException asnModelException) {
                return new SourceRange(0, 0);
            }
        }
    }
}

