/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModel;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.DialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IListAdapter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class CategoryFilterActionGroup
extends ActionGroup {
    private static int COUNTER = 0;
    private static final String FILTER_CATEGORY_ACTION_ID = "FilterCategoryActionId";
    private final String CATEGORY_MENU_GROUP_NAME = "CategoryMenuGroup" + COUNTER++;
    private static final int MAX_NUMBER_OF_CATEGORIES_IN_MENU = 5;
    private final StructuredViewer fViewer;
    private final String fViewerId;
    private final CategoryFilter fFilter;
    private final HashSet fFilteredCategories;
    private IAsnElement[] fInputElement;
    private final CategoryFilterMenuAction fMenuAction;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private final LinkedHashMap fLRUList;
    private boolean fFilterUncategorizedMembers;

    public CategoryFilterActionGroup(StructuredViewer viewer, String viewerId, IAsnElement[] input) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        Assert.isLegal((viewerId != null ? 1 : 0) != 0);
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fLRUList = new LinkedHashMap(10, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 5;
            }
        };
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInputElement = input;
        this.fFilter = new CategoryFilter();
        this.fFilteredCategories = new HashSet();
        this.loadSettings();
        this.fMenuAction = new CategoryFilterMenuAction();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    public void setInput(IAsnElement[] input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fInputElement = input;
    }

    private void loadSettings() {
        int i;
        String[] categories;
        this.fFilteredCategories.clear();
        IPreferenceStore store = AsnPlugin.getDefault().getPreferenceStore();
        String string = store.getString(this.getPreferenceKey());
        if (string != null && string.length() > 0) {
            categories = string.split(";");
            i = 0;
            while (i < categories.length) {
                this.fFilteredCategories.add(categories[i]);
                ++i;
            }
        }
        if ((string = store.getString(this.getPreferenceKey() + ".LRU")) != null && string.length() > 0) {
            categories = string.split(";");
            i = categories.length - 1;
            while (i >= 0) {
                this.fLRUList.put(categories[i], categories[i]);
                --i;
            }
        }
        this.fFilterUncategorizedMembers = store.getBoolean(this.getPreferenceKey() + ".FilterUncategorized");
    }

    private void storeSettings() {
        IPreferenceStore store = AsnPlugin.getDefault().getPreferenceStore();
        if (this.fFilteredCategories.size() == 0) {
            store.setValue(this.getPreferenceKey(), "");
        } else {
            StringBuffer buf = new StringBuffer();
            Iterator<Object> iter = this.fFilteredCategories.iterator();
            String element = (String)iter.next();
            buf.append(element);
            while (iter.hasNext()) {
                element = (String)iter.next();
                buf.append(';');
                buf.append(element);
            }
            store.setValue(this.getPreferenceKey(), buf.toString());
            buf = new StringBuffer();
            iter = this.fLRUList.values().iterator();
            element = (String)iter.next();
            buf.append(element);
            while (iter.hasNext()) {
                element = (String)iter.next();
                buf.append(';');
                buf.append(element);
            }
            store.setValue(this.getPreferenceKey() + ".LRU", buf.toString());
            store.setValue(this.getPreferenceKey() + ".FilterUncategorized", this.fFilterUncategorizedMembers);
        }
    }

    public void contributeToViewMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator(this.CATEGORY_MENU_GROUP_NAME));
        menuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)this.fMenuAction);
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!manager.isVisible()) {
                    return;
                }
                CategoryFilterActionGroup.this.updateMenu(manager);
            }
        };
        menuManager.addMenuListener(this.fMenuListener);
        this.fMenuManager = menuManager;
    }

    public void dispose() {
        super.dispose();
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
            this.fMenuManager = null;
            this.fMenuListener = null;
        }
    }

    private void updateMenu(IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (item != null && item.getId() != null && item.getId().equals(FILTER_CATEGORY_ACTION_ID)) {
                    manager.remove(item);
                }
                ++i;
            }
        }
        ArrayList menuEntries = new ArrayList();
        boolean hasUncategorizedMembers = this.getMenuCategories(menuEntries);
        Collections.sort(menuEntries, Collator.getInstance());
        if (menuEntries.size() > 0 && hasUncategorizedMembers) {
            manager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new FilterUncategorizedMembersAction());
        }
        int count = 0;
        for (String category : menuEntries) {
            manager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new CategoryFilterAction(category, count + 1));
            ++count;
        }
    }

    private boolean getMenuCategories(List result) {
        final HashSet categories = new HashSet();
        final HashSet foundLRUCategories = new HashSet();
        final boolean[] hasUncategorizedMember = new boolean[1];
        int i = 0;
        while (!(i >= this.fInputElement.length || hasUncategorizedMember[0] && foundLRUCategories.size() >= 5)) {
            this.collectCategories(this.fInputElement[i], new IResultCollector(){

                @Override
                public boolean accept(String[] cats) {
                    if (cats.length > 0) {
                        int j = 0;
                        while (j < cats.length) {
                            String category = cats[j];
                            categories.add(category);
                            if (CategoryFilterActionGroup.this.fLRUList.containsKey(category)) {
                                foundLRUCategories.add(category);
                            }
                            ++j;
                        }
                    } else {
                        hasUncategorizedMember[0] = true;
                    }
                    return hasUncategorizedMember[0] && foundLRUCategories.size() >= 5;
                }
            });
            ++i;
        }
        int count = 0;
        for (String element : foundLRUCategories) {
            result.add(element);
            ++count;
        }
        if (count < 5) {
            ArrayList sortedCategories = new ArrayList(categories);
            Collections.sort(sortedCategories, Collator.getInstance());
            Iterator iter = sortedCategories.iterator();
            while (iter.hasNext() && count < 5) {
                String element = (String)iter.next();
                if (foundLRUCategories.contains(element)) continue;
                result.add(element);
                ++count;
            }
        }
        return hasUncategorizedMember[0];
    }

    private boolean collectCategories(IAsnElement element, IResultCollector collector) {
        try {
            if (element instanceof ICompilationUnit) {
                return this.processChildren(((ICompilationUnit)element).getChildren(), collector);
            }
            if (element instanceof IAsnModel) {
                return this.processChildren(((IAsnModel)element).getChildren(), collector);
            }
            if (element instanceof IAsnProject) {
                return this.processChildren(((IAsnProject)element).getChildren(), collector);
            }
            if (element instanceof ISourceFolder) {
                return this.processChildren(((ISourceFolder)element).getChildren(), collector);
            }
            return false;
        }
        catch (AsnModelException e) {
            AsnPlugin.log(e);
            return true;
        }
    }

    private boolean processChildren(IAsnElement[] children, IResultCollector collector) {
        int i = 0;
        while (i < children.length) {
            if (this.collectCategories(children[i], collector)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireSelectionChange() {
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CategoryFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    private String getPreferenceKey() {
        return "CategoryFilterActionGroup." + this.fViewerId;
    }

    private void showCategorySelectionDialog(IAsnElement[] input) {
        final HashSet categories = new HashSet();
        int i = 0;
        while (i < input.length) {
            this.collectCategories(input[i], new IResultCollector(){

                @Override
                public boolean accept(String[] cats) {
                    int j = 0;
                    while (j < cats.length) {
                        categories.add(cats[j]);
                        ++j;
                    }
                    return false;
                }
            });
            ++i;
        }
        CategoryFilterSelectionDialog dialog = new CategoryFilterSelectionDialog(this.fViewer.getControl().getShell(), new ArrayList(categories), new ArrayList(this.fFilteredCategories));
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            for (String category : categories) {
                if (this.contains(selected, category)) {
                    if (!this.fFilteredCategories.remove(category)) continue;
                    this.fLRUList.put(category, category);
                    continue;
                }
                if (!this.fFilteredCategories.add(category)) continue;
                this.fLRUList.put(category, category);
            }
            this.storeSettings();
            this.fireSelectionChange();
        }
    }

    private boolean contains(Object[] selected, String category) {
        int i = 0;
        while (i < selected.length) {
            if (selected[i].equals(category)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class CategoryFilter
    extends ViewerFilter {
        private CategoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IMember) {
                IMember cfr_ignored_0 = (IMember)element;
                return !CategoryFilterActionGroup.this.fFilterUncategorizedMembers;
            }
            return true;
        }
    }

    private class CategoryFilterAction
    extends Action {
        private final String fCategory;

        public CategoryFilterAction(String category, int count) {
            this.fCategory = category;
            StringBuffer buf = new StringBuffer();
            buf.append('&').append(count).append(' ').append(this.fCategory);
            this.setText(buf.toString());
            this.setChecked(!CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory));
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            super.run();
            if (CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory)) {
                CategoryFilterActionGroup.this.fFilteredCategories.remove(this.fCategory);
            } else {
                CategoryFilterActionGroup.this.fFilteredCategories.add(this.fCategory);
            }
            CategoryFilterActionGroup.this.fLRUList.put(this.fCategory, this.fCategory);
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private class CategoryFilterMenuAction
    extends Action {
        public CategoryFilterMenuAction() {
            this.setDescription(ActionMessages.CategoryFilterActionGroup_ShowCategoriesActionDescription);
            this.setToolTipText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesToolTip);
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesLabel);
            AsnPluginImages.setLocalImageDescriptors((IAction)this, "category_menu.gif");
        }

        public void run() {
            CategoryFilterActionGroup.this.showCategorySelectionDialog(CategoryFilterActionGroup.this.fInputElement);
        }
    }

    private class CategoryFilterSelectionDialog
    extends SelectionStatusDialog
    implements IListAdapter {
        private static final int SELECT_ALL = 0;
        private static final int DESELECT_ALL = 1;
        private final CheckedListDialogField fCategoryList;

        public CategoryFilterSelectionDialog(Shell parent, List categories, List selectedCategories) {
            super(parent);
            this.setTitle(ActionMessages.CategoryFilterActionGroup_AsnCategoryFilter_title);
            String[] buttons = new String[]{ActionMessages.CategoryFilterActionGroup_SelectAllCategories, ActionMessages.CategoryFilterActionGroup_DeselectAllCategories};
            this.fCategoryList = new CheckedListDialogField(this, buttons, new ILabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return (String)element;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.fCategoryList.addElements(categories);
            this.fCategoryList.setViewerSorter(new ViewerSorter());
            this.fCategoryList.setLabelText(ActionMessages.CategoryFilterActionGroup_SelectCategoriesDescription);
            this.fCategoryList.checkAll(true);
            for (String selected : selectedCategories) {
                this.fCategoryList.setChecked(selected, false);
            }
            if (categories.size() == 0) {
                this.fCategoryList.setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setFont(parent.getFont());
            Composite list = new Composite(composite, 0);
            list.setFont(composite.getFont());
            LayoutUtil.doDefaultLayout(list, new DialogField[]{this.fCategoryList}, true);
            LayoutUtil.setHorizontalGrabbing(this.fCategoryList.getListControl(null));
            Dialog.applyDialogFont((Control)composite);
            this.setHelpAvailable(false);
            return composite;
        }

        protected void computeResult() {
            this.setResult(this.fCategoryList.getCheckedElements());
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                this.fCategoryList.checkAll(true);
                this.fCategoryList.refresh();
            } else if (index == 1) {
                this.fCategoryList.checkAll(false);
                this.fCategoryList.refresh();
            }
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            if (selectedElements.size() == 1) {
                Object selected;
                this.fCategoryList.setChecked(selected, !this.fCategoryList.isChecked(selected = selectedElements.get(0)));
            }
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }
    }

    private class FilterUncategorizedMembersAction
    extends Action {
        public FilterUncategorizedMembersAction() {
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowUncategorizedMembers);
            this.setChecked(!CategoryFilterActionGroup.this.fFilterUncategorizedMembers);
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            CategoryFilterActionGroup.this.fFilterUncategorizedMembers = !CategoryFilterActionGroup.this.fFilterUncategorizedMembers;
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private static interface IResultCollector {
        public boolean accept(String[] var1);
    }
}

