/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.dialogs.StatusInfo;
import org.asnlab.asndt.internal.ui.dialogs.StatusUtil;
import org.asnlab.asndt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.asnlab.asndt.internal.ui.preferences.OverlayPreferenceStore;
import org.asnlab.asndt.internal.ui.preferences.PreferencesMessages;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverDescriptor;
import org.asnlab.asndt.internal.ui.util.PixelConverter;
import org.asnlab.asndt.internal.ui.util.SWTUtil;
import org.asnlab.asndt.internal.ui.util.TableLayoutComposite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class AsnEditorHoverConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String DELIMITER = PreferencesMessages.AsnEditorHoverConfigurationBlock_delimiter;
    private static final int ENABLED_PROP = 0;
    private static final int MODIFIER_PROP = 1;
    private OverlayPreferenceStore fStore;
    private HoverConfig[] fHoverConfigs;
    private Text fModifierEditor;
    private Table fHoverTable;
    private TableViewer fHoverTableViewer;
    private TableColumn fNameColumn;
    private TableColumn fModifierColumn;
    private Text fDescription;
    private Button fShowHoverAffordanceCheckbox;
    private PreferencePage fMainPreferencePage;
    private StatusInfo fStatus;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AsnEditorHoverConfigurationBlock.this.fStore.setValue((String)AsnEditorHoverConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AsnEditorHoverConfigurationBlock.this.fStore.setValue((String)AsnEditorHoverConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public AsnEditorHoverConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.fMainPreferencePage = mainPreferencePage;
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_annotation_roll_over"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifiers"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hoverModifierMasks"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite hoverComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        hoverComposite.setLayout((Layout)layout);
        String rollOverLabel = PreferencesMessages.AsnEditorHoverConfigurationBlock_annotationRollover;
        this.addCheckBox(hoverComposite, rollOverLabel, "editor_annotation_roll_over", 0);
        this.fShowHoverAffordanceCheckbox = new Button(hoverComposite, 32);
        this.fShowHoverAffordanceCheckbox.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_showAffordance);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 2;
        this.fShowHoverAffordanceCheckbox.setLayoutData((Object)gd);
        this.addFiller(hoverComposite);
        Label label = new Label(hoverComposite, 0);
        label.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_hoverPreferences);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        TableLayoutComposite layouter = new TableLayoutComposite(hoverComposite, 0);
        this.addColumnLayoutData(layouter);
        this.fHoverTable = new Table((Composite)layouter, 68388);
        this.fHoverTable.setHeaderVisible(true);
        this.fHoverTable.setLinesVisible(true);
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getTableHeightHint(this.fHoverTable, 10);
        gd.horizontalSpan = 2;
        gd.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(30);
        layouter.setLayoutData(gd);
        this.fHoverTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AsnEditorHoverConfigurationBlock.this.handleHoverListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.fHoverTable.setLayout((Layout)tableLayout);
        this.fNameColumn = new TableColumn(this.fHoverTable, 0);
        this.fNameColumn.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_nameColumnTitle);
        this.fNameColumn.setResizable(true);
        this.fModifierColumn = new TableColumn(this.fHoverTable, 0);
        this.fModifierColumn.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_modifierColumnTitle);
        this.fModifierColumn.setResizable(true);
        this.fHoverTableViewer = new CheckboxTableViewer(this.fHoverTable);
        this.fHoverTableViewer.setUseHashlookup(true);
        this.fHoverTableViewer.setContentProvider((IContentProvider)new AsnEditorTextHoverDescriptorContentProvider());
        this.fHoverTableViewer.setLabelProvider((IBaseLabelProvider)new AsnEditorTextHoverDescriptorLabelProvider());
        ((CheckboxTableViewer)this.fHoverTableViewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String id = ((AsnEditorTextHoverDescriptor)event.getElement()).getId();
                if (id == null) {
                    return;
                }
                AsnEditorTextHoverDescriptor[] descriptors = AsnEditorHoverConfigurationBlock.this.getContributedHovers();
                HoverConfig hoverConfig = null;
                int i = 0;
                int length = AsnEditorHoverConfigurationBlock.this.fHoverConfigs.length;
                while (i < length) {
                    if (id.equals(descriptors[i].getId())) {
                        hoverConfig = AsnEditorHoverConfigurationBlock.this.fHoverConfigs[i];
                        hoverConfig.fIsEnabled = event.getChecked();
                        AsnEditorHoverConfigurationBlock.this.fModifierEditor.setEnabled(event.getChecked());
                        AsnEditorHoverConfigurationBlock.this.fHoverTableViewer.setSelection((ISelection)new StructuredSelection((Object)descriptors[i]));
                    }
                    ++i;
                }
                AsnEditorHoverConfigurationBlock.this.handleHoverListSelection();
                AsnEditorHoverConfigurationBlock.this.updateStatus(hoverConfig);
            }
        });
        label = new Label(hoverComposite, 16384);
        label.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_keyModifier);
        this.fModifierEditor = new Text(hoverComposite, 2048);
        gd = new GridData(256);
        this.fModifierEditor.setLayoutData((Object)gd);
        this.fModifierEditor.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String text = AsnEditorHoverConfigurationBlock.this.fModifierEditor.getText();
                    Point selection = AsnEditorHoverConfigurationBlock.this.fModifierEditor.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(text.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    i = selection.y;
                    while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < text.length() && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_insertDelimiterAndModifierAndDelimiter, new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_insertDelimiterAndModifier, new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_insertModifierAndDelimiter, new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                    if (insertString != null) {
                        AsnEditorHoverConfigurationBlock.this.fModifierEditor.insert(insertString);
                    }
                }
            }
        });
        this.fModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AsnEditorHoverConfigurationBlock.this.handleModifierModified();
            }
        });
        Label descriptionLabel = new Label(hoverComposite, 16384);
        descriptionLabel.setText(PreferencesMessages.AsnEditorHoverConfigurationBlock_description);
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)gd);
        this.fDescription = new Text(hoverComposite, 18506);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gd);
        this.initialize();
        Dialog.applyDialogFont((Control)hoverComposite);
        return hoverComposite;
    }

    private void addColumnLayoutData(TableLayoutComposite layouter) {
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
    }

    private AsnEditorTextHoverDescriptor[] getContributedHovers() {
        return AsnPlugin.getDefault().getAsnEditorTextHoverDescriptors();
    }

    @Override
    public void initialize() {
        AsnEditorTextHoverDescriptor[] hoverDescs = this.getContributedHovers();
        this.fHoverConfigs = new HoverConfig[hoverDescs.length];
        int i = 0;
        while (i < hoverDescs.length) {
            this.fHoverConfigs[i] = new HoverConfig(hoverDescs[i].getModifierString(), hoverDescs[i].getStateMask(), hoverDescs[i].isEnabled());
            ++i;
        }
        this.fHoverTableViewer.setInput((Object)hoverDescs);
        this.initializeFields();
    }

    void initializeFields() {
        this.fShowHoverAffordanceCheckbox.setSelection(this.fStore.getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE"));
        this.fModifierEditor.setEnabled(false);
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        int i = 0;
        while (i < this.fHoverConfigs.length) {
            this.fHoverTable.getItem(i).setChecked(this.fHoverConfigs[i].fIsEnabled);
            ++i;
        }
        this.fHoverTableViewer.refresh();
    }

    @Override
    public void performOk() {
        StringBuffer buf = new StringBuffer();
        StringBuffer maskBuf = new StringBuffer();
        int i = 0;
        while (i < this.fHoverConfigs.length) {
            String modifier;
            buf.append(this.getContributedHovers()[i].getId());
            buf.append(";");
            if (!this.fHoverConfigs[i].fIsEnabled) {
                buf.append("!");
            }
            if ((modifier = this.fHoverConfigs[i].fModifierString) == null || modifier.length() == 0) {
                modifier = "0";
            }
            buf.append(modifier);
            buf.append(";");
            maskBuf.append(this.getContributedHovers()[i].getId());
            maskBuf.append(";");
            maskBuf.append(this.fHoverConfigs[i].fStateMask);
            maskBuf.append(";");
            ++i;
        }
        this.fStore.setValue("hoverModifiers", buf.toString());
        this.fStore.setValue("hoverModifierMasks", maskBuf.toString());
        this.fStore.setValue("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE", this.fShowHoverAffordanceCheckbox.getSelection());
        AsnPlugin.getDefault().resetAsnEditorTextHoverDescriptors();
    }

    @Override
    public void performDefaults() {
        this.restoreFromPreferences();
        this.initializeFields();
        this.updateStatus(null);
    }

    private void restoreFromPreferences() {
        this.fShowHoverAffordanceCheckbox.setSelection(this.fStore.getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE"));
        String compiledTextHoverModifiers = this.fStore.getString("hoverModifiers");
        StringTokenizer tokenizer = new StringTokenizer(compiledTextHoverModifiers, ";");
        HashMap<String, String> idToModifier = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifier.put(id, tokenizer.nextToken());
        }
        String compiledTextHoverModifierMasks = AsnPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        tokenizer = new StringTokenizer(compiledTextHoverModifierMasks, ";");
        HashMap<String, String> idToModifierMask = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifierMask.put(id, tokenizer.nextToken());
        }
        int i = 0;
        while (i < this.fHoverConfigs.length) {
            String modifierString = (String)idToModifier.get(this.getContributedHovers()[i].getId());
            boolean enabled = true;
            if (modifierString == null) {
                modifierString = "!";
            }
            if (modifierString.startsWith("!")) {
                enabled = false;
                modifierString = modifierString.substring(1);
            }
            if (modifierString.equals("0")) {
                modifierString = "";
            }
            this.fHoverConfigs[i].fModifierString = modifierString;
            this.fHoverConfigs[i].fIsEnabled = enabled;
            this.fHoverConfigs[i].fStateMask = AsnEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (this.fHoverConfigs[i].fStateMask == -1) {
                try {
                    this.fHoverConfigs[i].fStateMask = Integer.parseInt((String)idToModifierMask.get(this.getContributedHovers()[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHoverConfigs[i].fStateMask = -1;
                }
            }
            ++i;
        }
    }

    private void handleModifierModified() {
        String modifiers;
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            return;
        }
        this.fHoverConfigs[i].fModifierString = modifiers = this.fModifierEditor.getText();
        this.fHoverConfigs[i].fStateMask = AsnEditorTextHoverDescriptor.computeStateMask(modifiers);
        this.fHoverTableViewer.refresh((Object)this.getContributedHovers()[i]);
        this.updateStatus(this.fHoverConfigs[i]);
    }

    private void handleHoverListSelection() {
        int i = this.fHoverTable.getSelectionIndex();
        if (i == -1) {
            if (this.fHoverTable.getSelectionCount() == 0) {
                this.fModifierEditor.setEnabled(false);
            }
            return;
        }
        boolean enabled = this.fHoverConfigs[i].fIsEnabled;
        this.fModifierEditor.setEnabled(enabled);
        this.fModifierEditor.setText(this.fHoverConfigs[i].fModifierString);
        String description = this.getContributedHovers()[i].getDescription();
        if (description == null) {
            description = "";
        }
        this.fDescription.setText(description);
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    private void updateStatus(HoverConfig hoverConfig) {
        this.fStatus = hoverConfig != null && hoverConfig.fIsEnabled && hoverConfig.fStateMask == -1 ? new StatusInfo(4, Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_modifierIsNotValid, hoverConfig.fModifierString)) : new StatusInfo();
        int i = 0;
        HashMap<Integer, String> stateMasks = new HashMap<Integer, String>(this.fHoverConfigs.length);
        while (this.fStatus.isOK() && i < this.fHoverConfigs.length) {
            if (this.fHoverConfigs[i].fIsEnabled) {
                String label = this.getContributedHovers()[i].getLabel();
                Integer stateMask = new Integer(this.fHoverConfigs[i].fStateMask);
                if (this.fHoverConfigs[i].fStateMask == -1) {
                    this.fStatus = new StatusInfo(4, Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_modifierIsNotValidForHover, new String[]{this.fHoverConfigs[i].fModifierString, label}));
                } else if (stateMasks.containsKey(stateMask)) {
                    this.fStatus = new StatusInfo(4, Messages.format(PreferencesMessages.AsnEditorHoverConfigurationBlock_duplicateModifier, new String[]{label, (String)stateMasks.get(stateMask)}));
                } else {
                    stateMasks.put(stateMask, label);
                }
            }
            ++i;
        }
        this.fMainPreferencePage.setValid(this.fStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, this.fStatus);
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    @Override
    public void dispose() {
    }

    private class AsnEditorTextHoverDescriptorContentProvider
    implements IStructuredContentProvider {
        private AsnEditorTextHoverDescriptorContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return (Object[])element;
        }
    }

    private class AsnEditorTextHoverDescriptorLabelProvider
    implements ITableLabelProvider {
        private AsnEditorTextHoverDescriptorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((AsnEditorTextHoverDescriptor)element).getLabel();
                }
                case 1: {
                    TableItem item = (TableItem)AsnEditorHoverConfigurationBlock.this.fHoverTableViewer.testFindItem(element);
                    int index = AsnEditorHoverConfigurationBlock.this.fHoverTable.indexOf(item);
                    return AsnEditorHoverConfigurationBlock.this.fHoverConfigs[index].fModifierString;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class HoverConfig {
        private String fModifierString;
        private boolean fIsEnabled;
        private int fStateMask;

        private HoverConfig(String modifier, int stateMask, boolean enabled) {
            this.fModifierString = modifier;
            this.fIsEnabled = enabled;
            this.fStateMask = stateMask;
        }
    }
}

