/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.refactoring.RefactoringMessages;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class MoveAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public MoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.MoveAction_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.move_action");
    }

    public MoveAction(CompilationUnitEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(RefactoringMessages.MoveAction_text);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.move_action");
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.setEnabled(this.computeEnableState());
    }

    @Override
    public void run(IStructuredSelection selection) {
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
                return;
            }
            if (this.tryReorgMove(selection)) {
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveAction_Move, (String)RefactoringMessages.MoveAction_select);
        }
        catch (AsnModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private boolean tryReorgMove(ITextSelection selection) throws AsnModelException {
        IAsnElement element = SelectionConverter.getElementAtOffset(this.fEditor);
        return element != null;
    }

    @Override
    public void update(ISelection selection) {
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return false;
    }
}

