/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnUIMessages;
import org.asnlab.asndt.internal.ui.util.SWTUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    private static final List EMPTY_LIST = new ArrayList(0);

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.fProvider = provider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.convertSelection().size() > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        List resources = this.convertSelection();
        event.data = resources.toArray(new IResource[resources.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.detail == 2) {
            this.handleFinishedDropMove(event);
        }
    }

    private List convertSelection() {
        ISelection s = this.fProvider.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return EMPTY_LIST;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        ArrayList<IResource> result = new ArrayList<IResource>(selection.size());
        for (Object element : selection) {
            IResource resource = null;
            if (element instanceof IAsnElement) {
                resource = ((IAsnElement)element).getResource();
            } else if (element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            if (resource == null) continue;
            result.add(resource);
        }
        return result;
    }

    private void handleFinishedDropMove(DragSourceEvent event) {
        MultiStatus status = new MultiStatus(AsnPlugin.getPluginId(), 10001, AsnUIMessages.ResourceTransferDragAdapter_cannot_delete_resource, null);
        List resources = this.convertSelection();
        for (IResource resource : resources) {
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (status.getChildren().length > 0) {
            Shell parent = SWTUtil.getShell(event.widget);
            ErrorDialog error = new ErrorDialog(parent, AsnUIMessages.ResourceTransferDragAdapter_moving_resource, AsnUIMessages.ResourceTransferDragAdapter_cannot_delete_files, (IStatus)status, 4);
            error.open();
        }
    }
}

