/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.ElementChangedEvent;
import org.asnlab.asndt.core.IElementChangedListener;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.text.AsnCompositeReconcilingStrategy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;
    private ShellListener fActivationListener;
    private Object fMutex;
    private IElementChangedListener fAsnElementChangedListener;
    private volatile boolean fHasAsnModelChanged = true;
    private volatile boolean fIsEditorActive = true;
    private volatile boolean fIsReconciling = false;
    private boolean fIninitalProcessDone = false;

    public AsnReconciler(ITextEditor editor, AsnCompositeReconcilingStrategy strategy, boolean isIncremental) {
        super((IReconcilingStrategy)strategy, isIncremental);
        this.fTextEditor = editor;
        this.fMutex = editor instanceof CompilationUnitEditor ? ((CompilationUnitEditor)editor).getReconcilerLock() : new Object();
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)textViewer.getTextWidget());
        Shell shell = window.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fAsnElementChangedListener = new ElementChangedListener();
        AsnCore.addElementChangedListener((IElementChangedListener)this.fAsnElementChangedListener);
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        AsnCore.removeElementChangedListener((IElementChangedListener)this.fAsnElementChangedListener);
        this.fAsnElementChangedListener = null;
        super.uninstall();
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        AsnCompositeReconcilingStrategy strategy = (AsnCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(false);
    }

    protected void aboutToBeReconciled() {
        AsnCompositeReconcilingStrategy strategy = (AsnCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        AsnCompositeReconcilingStrategy strategy = (AsnCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fIsReconciling = true;
            super.process(dirtyRegion);
            this.fIsReconciling = false;
        }
    }

    private synchronized boolean hasAsnModelChanged() {
        return this.fHasAsnModelChanged;
    }

    private synchronized void setAsnModelChanged(boolean state) {
        this.fHasAsnModelChanged = state;
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean state) {
        this.fIsEditorActive = state;
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible()) {
                if (AsnReconciler.this.hasAsnModelChanged()) {
                    AsnReconciler.this.forceReconciling();
                }
                AsnReconciler.this.setEditorActive(true);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.getShell() == e.getSource()) {
                AsnReconciler.this.setAsnModelChanged(false);
                AsnReconciler.this.setEditorActive(false);
            }
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (event.getDelta().getFlags() == 524288) {
                return;
            }
            AsnReconciler.this.setAsnModelChanged(true);
            if (!AsnReconciler.this.fIsReconciling && AsnReconciler.this.isEditorActive()) {
                AsnReconciler.this.forceReconciling();
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == AsnReconciler.this.fTextEditor) {
                if (AsnReconciler.this.hasAsnModelChanged()) {
                    AsnReconciler.this.forceReconciling();
                }
                AsnReconciler.this.setEditorActive(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == AsnReconciler.this.fTextEditor) {
                AsnReconciler.this.setAsnModelChanged(false);
                AsnReconciler.this.setEditorActive(false);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

