/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.actions.OpenActionUtil;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private AsnEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.open_action");
    }

    public OpenAction(AsnEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false) != null);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof ISourceReference || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run(ITextSelection selection) {
        if (!this.isProcessable()) {
            return;
        }
        try {
            IAsnElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, false);
            if (elements == null || elements.length == 0) {
                IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            IAsnElement element = elements[0];
            if (elements.length > 1 && (element = OpenActionUtil.selectAsnElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
                return;
            }
            int type = element.getElementType();
            if (type == 2 || type == 4) {
                element = EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false);
            }
            this.run(new Object[]{element});
        }
        catch (InvocationTargetException e) {
            this.showError(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isProcessable() {
        IAsnElement je;
        if (this.fEditor != null && (je = EditorUtility.getEditorInputAsnElement((IEditorPart)this.fEditor, false)) instanceof ICompilationUnit && !AsnModelUtil.isPrimary((ICompilationUnit)je)) {
            return true;
        }
        return ActionUtil.isProcessable(this.getShell(), this.fEditor);
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block10: {
                Object element = elements[i];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (AsnModelException e) {
                    AsnPlugin.log((IStatus)new Status(4, AsnPlugin.getPluginId(), 10001, ActionMessages.OpenAction_error_message, (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof IAsnElement) {
                        name = ((IAsnElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)Messages.format(ActionMessages.OpenAction_error_messageArgs, new String[]{name, x.getMessage()}));
                }
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) throws AsnModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(InvocationTargetException e) {
        ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

