/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.refactoring.RefactoringMessages;
import org.asnlab.asndt.internal.ui.refactoring.actions.RenameAsnElementAction;
import org.asnlab.asndt.internal.ui.refactoring.actions.RenameResourceAction;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class RenameAction
extends SelectionDispatchAction {
    private RenameAsnElementAction fRenameAsnElement;
    private RenameResourceAction fRenameResource;
    private CompilationUnitEditor fEditor;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RenameAction_text);
        this.fRenameAsnElement = new RenameAsnElementAction(site);
        this.fRenameAsnElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(site);
        this.fRenameResource.setText(this.getText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.rename_action");
    }

    public RenameAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.fRenameAsnElement = new RenameAsnElementAction(editor);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameAsnElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    @Override
    public void update(ISelection selection) {
        this.fRenameAsnElement.update(selection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenameAsnElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameAsnElement.isEnabled();
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (this.fRenameAsnElement.isEnabled()) {
            this.fRenameAsnElement.run(selection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(selection);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.fRenameAsnElement.canRun()) {
            this.fRenameAsnElement.run(selection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAction_rename, (String)RefactoringMessages.RenameAction_unavailable);
        }
    }
}

