/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionGroup;

public class MultiActionGroup
extends ActionGroup {
    public IAction[] NO_ACTIONS = new IAction[0];
    private IAction[] fActions;
    private int fCurrentSelection;
    private MenuItem[] fItems;

    public MultiActionGroup(IAction[] actions, int currentSelection) {
        this.setActions(actions, currentSelection);
    }

    protected MultiActionGroup() {
    }

    protected final void setActions(IAction[] actions, int currentSelection) {
        this.fCurrentSelection = currentSelection;
        this.fActions = actions;
    }

    protected void addActions(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        this.fItems = new MenuItem[this.fActions.length];
        int i = 0;
        while (i < this.fActions.length) {
            final int j = i++;
            viewMenu.add((IContributionItem)new ContributionItem(){

                public void fill(Menu menu, int index) {
                    int style = 32;
                    if ((MultiActionGroup.this.fActions[j].getStyle() & 8) != 0) {
                        style = 16;
                    }
                    MenuItem mi = new MenuItem(menu, style, index);
                    ImageDescriptor d = MultiActionGroup.this.fActions[j].getImageDescriptor();
                    mi.setImage(AsnPlugin.getImageDescriptorRegistry().get(d));
                    MultiActionGroup.this.fItems[j] = mi;
                    mi.setText(MultiActionGroup.this.fActions[j].getText());
                    mi.setSelection(MultiActionGroup.this.fCurrentSelection == j);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if ((this).MultiActionGroup.this.fCurrentSelection == j) {
                                (this).MultiActionGroup.this.fItems[(this).MultiActionGroup.this.fCurrentSelection].setSelection(true);
                                return;
                            }
                            (this).MultiActionGroup.this.fActions[j].run();
                            (this).MultiActionGroup.this.fItems[(this).MultiActionGroup.this.fCurrentSelection].setSelection(false);
                            (this).MultiActionGroup.this.fCurrentSelection = j;
                            (this).MultiActionGroup.this.fItems[(this).MultiActionGroup.this.fCurrentSelection].setSelection(true);
                        }
                    });
                }

                public boolean isDynamic() {
                    return false;
                }
            });
        }
    }
}

