/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnSourceViewer;
import org.asnlab.asndt.internal.ui.preferences.AsnSourcePreviewerUpdater;
import org.asnlab.asndt.internal.ui.text.SimpleAsnSourceViewerConfiguration;
import org.asnlab.asndt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public class AsnTemplatePreferencePage
extends TemplatePreferencePage
implements IWorkbenchPreferencePage {
    private TemplateVariableProcessor fTemplateProcessor;

    public AsnTemplatePreferencePage() {
        this.setPreferenceStore(AsnPlugin.getDefault().getPreferenceStore());
        this.setTemplateStore(AsnPlugin.getDefault().getTemplateStore());
        this.setContextTypeRegistry(AsnPlugin.getDefault().getTemplateContextRegistry());
        this.fTemplateProcessor = new TemplateVariableProcessor();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.asnlab.asndt.ui.asn_editor_preference_page_context");
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        AsnPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected String getFormatterPreferenceKey() {
        return "org.asnlab.asndt.ui.template.format";
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        TemplatePreferencePage.EditTemplateDialog dialog = new TemplatePreferencePage.EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected SourceViewer createViewer(Composite parent) {
        Document document = new Document();
        AsnTextTools tools = AsnPlugin.getDefault().getAsnTextTools();
        tools.setupAsnDocumentPartitioner((IDocument)document, "___asn_partitioning");
        IPreferenceStore store = AsnPlugin.getDefault().getCombinedPreferenceStore();
        AsnSourceViewer viewer = new AsnSourceViewer(parent, null, null, false, 2816, store);
        SimpleAsnSourceViewerConfiguration configuration = new SimpleAsnSourceViewerConfiguration(tools.getColorManager(), store, null, "___asn_partitioning", false);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.asnlab.asndt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new AsnSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        SourceViewer viewer = this.getViewer();
        if (selection.size() == 1 && selection.getFirstElement() instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            String contextId = template.getContextTypeId();
            TemplateContextType type = AsnPlugin.getDefault().getTemplateContextRegistry().getContextType(contextId);
            this.fTemplateProcessor.setContextType(type);
            IDocument doc = viewer.getDocument();
            Object start = null;
            start = "asndoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
            doc.set((String)start + template.getPattern());
            int startLen = ((String)start).length();
            viewer.setDocument(doc, startLen, doc.getLength() - startLen);
        } else {
            viewer.getDocument().set("");
        }
    }
}

